function PlotOneDim(Data,Results)

%This function creates a plot for the one-dimensional OSI model
Y=Results.Y;
m=size(Y,1);
clf
hold on
diff=1;         %The variable diff is the distance between variables on the x-as
%If labels of different variables overlap, this value may be increased.
k=0;
for j=1:m
    if any(Data.V(:,j))
        k=k+1;
        for i=1:length(Y{j})
            plot([diff*k diff*k],[0 Y{j}(i)],'.-','Markersize',10,'LineWidth',0.5,'Color','k')
            text(diff*k+0.05,Y{j}(i),Data.Vallabels{j}{i},'Fontsize',8)
        end
    end
end
set(gca,'XTicklabel','','XTickLabelMode','manual','Xtick',[]);
set(gca,'Xlim',[.8*diff (1+sum(any(Data.V)))*diff]);
ylim=get(gca,'Ylim');
k=0;
for j=1:m
    if any(Data.V(:,j))
        k=k+1;
        plot([diff*k diff*k],[ylim(1)-1 ylim(2)+1],'LineWidth',0.5,'Color','k')
        text(diff*k,ylim(2)+0.1,Data.Varlabels{j},'HorizontalAlignment','left','Fontsize',7)
    end
end
set(gca,'Ylim',ylim)
ylabel('Category quantification')
set(gcf,'Units','Normalized')
set(gcf,'Position',[0.02 0.04  .95 .85])